loadFruitTypes = {}

local modDir = g_currentModDirectory
local modName = g_currentModName

function loadFruitTypes.loadMapData(self, superFunc, xmlFile, missionInfo, baseDirectory)
    superFunc(self, xmlFile, missionInfo, baseDirectory)
    local xmlFile = loadXMLFile("mod_fruitTypes", modDir .. "xml/fruitTypes.xml")

    if xmlFile ~= nil then
        g_fruitTypeManager:loadFruitTypes(xmlFile, missionInfo, modDir, false)
        delete(xmlFile)
    end

    for converter, converterData in pairs(self.fruitTypeConverterLoadData) do
        local isMower = converter == self.converterNameToIndex["MOWER"]
        local isCombineMower = converter == self.converterNameToIndex["COMBINE_MOWER"]

        if self.fruitTypeConverters[converter] ~= nil and (isMower or isCombineMower) then
            for _, data in ipairs(converterData) do
                local fruitType = self:getFruitTypeByName(data.fruitTypeName)
                local fillType = g_fillTypeManager:getFillTypeByName(data.fillTypeName)
                if fruitType ~= nil and fillType ~= nil then
                    self.fruitTypeConverters[converter][fruitType.index] = {fillTypeIndex=fillType.index, conversionFactor=data.conversionFactor}
                end
            end
        end
    end

    return true
end

FruitTypeManager.loadMapData = Utils.overwrittenFunction(FruitTypeManager.loadMapData, loadFruitTypes.loadMapData)

FruitTypeManager.loadFruitTypes = Utils.overwrittenFunction(FruitTypeManager.loadFruitTypes, function (self, superFunc, xmlFile, missionInfo, baseDirectory, isBaseType)
    superFunc(self, xmlFile, missionInfo, baseDirectory, isBaseType)

    local function configureFruit(fruitName, cutFillTypeName)
        local fruit = g_fruitTypeManager:getFruitTypeByName(fruitName)
        if fruit == nil then
            Logging.warning("FruitType '%s' not found!", fruitName)
            return
        end

        local windrowFillType = g_fillTypeManager:getFillTypeByName("straw")
        if windrowFillType == nil then
            Logging.warning("Default windrow FillType 'STRAW' not found!")
            return
        end

        local windrowCutFillType = g_fillTypeManager:getFillTypeByName(cutFillTypeName)
        if windrowCutFillType == nil then
            Logging.warning("Windrow cut FillType '%s' not found for fruit '%s'!", cutFillTypeName, fruitName)
            return
        end

        fruit.hasWindrow = true
        fruit.windrowFillType = windrowFillType
        fruit.windrowName = windrowFillType.name
        fruit.windrowLiterPerSqm = 3.68
        self.windrowFillTypes[windrowFillType.index] = true
        self.fruitTypeIndexToWindrowFillTypeIndex[fruit.index] = windrowFillType.index
        self.fillTypeIndexToFruitTypeIndex[windrowFillType.index] = fruit.index

        fruit.windrowCutFillType = windrowCutFillType
        fruit.windrowCutFactor = 1.25
        self.windrowCutFillTypeIndexToFruitTypeIndex[windrowCutFillType.index] = fruit.index

        fruit.seedRequiredFieldType = nil
    end

    configureFruit("rice", "rice_cut")
    configureFruit("ricelonggrain", "ricelonggrain_cut")

    return true
end)