----------------------------------------------------------------------------
-- @Author: ViperGTS96------------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------

source(Utils.getFilename("realSpeedLimit.lua", g_currentModDirectory));

function installSpec()
	if g_specializationManager:getSpecializationByName("realSpeedLimit") == nil then
		if realSpeedLimit == nil then 
			print("ERROR: unable to find source file 'realSpeedLimit.lua'");
		else 
			for typeName, typeDef in pairs(g_vehicleTypeManager.types) do
				if typeDef ~= nil and (typeName ~= "locomotive") then 
					local isWashable = false;
					local hasEngine = false;
					for name, spec in pairs(typeDef.specializationsByName) do
						if name == "washable" then 
							isWashable = true;
						elseif name == "motorized" then 
							hasEngine = true;
						end;
					end;
					if isWashable and hasEngine then
						 if typeDef.specializationsByName["realSpeedLimit"] == nil then
							table.insert(typeDef.specializations, realSpeedLimit);
							table.insert(typeDef.specializationNames, "realSpeedLimit");
							typeDef.specializationsByName["realSpeedLimit"] = realSpeedLimit;
						end;
					end;
				end;
			end;
		end;	
	end;
end;

TypeManager.validateTypes = Utils.appendedFunction(TypeManager.validateTypes, installSpec);