RealMulcher = {}
RealMulcher.MOD_NAME = g_currentModName

--- Checks if prerequisites are present
---@param specializations table
---@return boolean
function RealMulcher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Mulcher, specializations)
end

--- Registers event listeners for the vehicle type
---@param vehicleType table
function RealMulcher.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", RealMulcher)
end

--- Registers overwritten functions for the vehicle type
---@param vehicleType table
function RealMulcher.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "processMulcherArea", RealMulcher.processMulcherArea)
end

--- Called on load
function RealMulcher:onLoad()
    self.spec_realMulcher = self[("spec_%s.realMulcher"):format(RealMulcher.MOD_NAME)]

	local initialized = false
	if self.spec_workArea.workAreas ~= nil then
		for _, workArea in pairs(self.spec_workArea.workAreas) do
			if workArea.type == WorkAreaType.MULCHER then
				initialized = true
				workArea.requiresOwnedFarmland = false	-- questo gestisce già il poter tagliare ovunque, rimangono poi solo le decorazioni
			end
		end
	end
	if not initialized then
		print("Error: RealMulcher initialization failed for " .. tostring(self:getFullName()) .. " !")
		return
	end
end

function RealMulcher:processMulcherArea(superFunc, workArea, dt)
    local spec = self.spec_realMulcher
	local realArea, area = superFunc(self, workArea, dt)

    local xs,_,zs = getWorldTranslation(workArea.start)
    local xw,_,zw = getWorldTranslation(workArea.width)
    local xh,_,zh = getWorldTranslation(workArea.height)

	FSDensityMapUtil.clearDecoArea(xs, zs, xw, zw, xh, zh) -- togli le decorazioni
    
    return realArea, area
end