--[[
Part of Production Storage Control FS25

Copyright (C) braeven 2025

Author: braeven

Important:
No modifications to this script are permitted without Braeven's permission.
You are not allowed to use part of this script without permission.
]]

ProductionStorageDialog = {}
local ProductionStorageDialog_mt = Class(ProductionStorageDialog, YesNoDialog)


function ProductionStorageDialog.register()
	local productionStorageDialog = ProductionStorageDialog.new()
	local path = Utils.getFilename("gui/productionStorageControl_storageDialog.xml", g_currentModDirectory)
	g_gui:loadGui(path, "ProductionStorageDialog", productionStorageDialog)
	ProductionStorageDialog.INSTANCE = productionStorageDialog
end


function ProductionStorageDialog.show(farmList, target, title, options, productionPoint)
	if ProductionStorageDialog.INSTANCE ~= nil then
		local dialog = ProductionStorageDialog.INSTANCE
		dialog.productionPoint = productionPoint
		dialog:setTitle(title)
		dialog:setText(g_i18n:getText("ProductionStorageControl_ChooseSpawnOptionsDialogText"))
		dialog:setFillTypes(options)
		dialog:setFarmList(farmList)
		dialog:setFoilColor(1)
		g_gui:showDialog("ProductionStorageDialog")
	end
end


function ProductionStorageDialog.new(target, custom_mt)
	local self = YesNoDialog.new(target, custom_mt or ProductionStorageDialog_mt)
	self.selectedFillType = 1
	self.selectedPackage = 1
	self.selectedAmount = 0
	self.selectedFarm = 1
	self.maxUnloadAmount = math.huge
	return self
end


function ProductionStorageDialog.createFromExistingGui(gui, guiName)
	ProductionStorageDialog.register()
	local callback = gui.callbackFunc
	local target = gui.target
	local title = gui.dialogTitle
	local fillTypesSelection = gui.fillTypesSelection
	ProductionStorageDialog.show(callback, target, title, fillTypesSelection)
end


--Auswahl verarbeiten
function ProductionStorageDialog:onClickOk()
	if self.selectedOption.openmenu ~= nil then
		self.productionPoint:openMenu()
	else
		local amount = self.amountElement:getState() - 1
		local selectedPackage = self.selectedOption.packages[self.selectedPackage]

		local pendingLiters = selectedPackage.capacity * amount
		if pendingLiters > self.selectedOption.fillLevel then
			pendingLiters = self.selectedOption.fillLevel
		end

		productionStorageControl_EventSpawn.sendEvent(self.productionPoint, self.farmList[self.selectedFarm].farmId, self.selectedFillType, pendingLiters, selectedPackage.width, selectedPackage.height, selectedPackage.length, selectedPackage.capacity, selectedPackage.type, selectedPackage.customEnvironment, selectedPackage.treeId, amount, self.selectedColor[1], self.selectedColor[2], self.selectedColor[3])
		self.fillTypesSelection = nil
		self:close()
	end
end


--Abbrechen
function ProductionStorageDialog:onClickBack()
	self:close()
end


--Angezeigten FillType ändern
function ProductionStorageDialog:onClickFillType(state)
	--FillTypeIndex bestimmen über State
	local i = 1
	for _, objectInfo in pairs(self.options) do
		if i == state then
			self.selectedFillType = objectInfo.fillTypeIndex
			self.selectedOption = objectInfo
			self.fillTypeIcon:setImageFilename(objectInfo.fillTypeIcon)
			break
		end
		i = i + 1
	end

	self:setFillTypePackages(self.selectedFillType)
end


--Angezeigte Verpackung ändern
function ProductionStorageDialog:onClickPackages(state)
	self.selectedPackage = state

	local selectedPackage = self.selectedOption.packages[self.selectedPackage]

	local amountTexts = {}

	--ModIcon anpassen
	self.modIcon:setImageFilename(selectedPackage.modIcon)

	if self.selectedOption.openmenu == nil then
		for i = 0, selectedPackage.max do
			local text = string.format("%d / %d", i, selectedPackage.max)
			local amount = i * selectedPackage.capacity
			if amount > self.selectedOption.fillLevel then
				amount = self.selectedOption.fillLevel
			end
			text = text .. " ("..g_i18n:formatVolume(amount, 0 , self.selectedOption.unitShort)..")"
			table.insert(amountTexts, text)
		end
	end

	self.maxUnloadAmount = selectedPackage.max
	self.amountElement:setTexts(amountTexts)
	self.selectedAmount = 0
	self.amountElement:setState(self.selectedAmount, true)
end


--Slider Position ändern
function ProductionStorageDialog:onClickAmount(state)
	self.selectedAmount = state
end


--Dialog-Titel einstellen
function ProductionStorageDialog:setTitle(title)
	ProductionStorageDialog:superClass().setTitle(self, title)
	self.dialogTitle = title
end


--Optionen hinterlegen
function ProductionStorageDialog:setFillTypes(options)
	self.options = options
	local objectInfoTable = {}

	for _, objectInfo in pairs(options) do
		if objectInfo.title ~= nil then
			table.insert(objectInfoTable, objectInfo.title)
			if self.selectedFillType == nil then
				self.selectedFillType = objectInfo.fillTypeIndex
				self.selectedOption = objectInfo
				if objectInfo.icon ~= nil then
					self.icon:setImageFilename(objectInfo.icon)
				end
			end
		end
	end

	self.fillTypeElement:setTexts(objectInfoTable)
	self.fillTypeElement:setState(1, true)
	self:setFillTypePackages(self.selectedFillType)
end


--Optionen hinterlegen
function ProductionStorageDialog:setFarmList(farmList)
	self.farmList = farmList
	local state = 1
	local objectInfoTable = {}
	for id, farm in pairs(farmList) do
		table.insert(objectInfoTable, farm.name)
		--Richtige Vorauswahl der Spieler-Farm
		if g_localPlayer:getFarmId() == farm.farmId then
			state = id
		end
	end

	local color = Farm.COLORS[1]

	if not g_currentMission.missionDynamicInfo.isMultiplayer then
		color = Farm.COLOR_SINGLEPLAYER
		self.farmIcon:setImageFilename(productionStorageControl.emptyIcon)
	end

	self.farmIDElement:setTexts(objectInfoTable)
	self.farmIDElement.textElement:setTextColor(color[1], color[2], color[3], color[4])
	self.farmIDElement:setState(state, true)
end


function ProductionStorageDialog:onClickIDElement(state)
	self.selectedFarm = state

	local selectedFarm = self.farmList[self.selectedFarm]
	local color = Farm.COLORS[selectedFarm.color]
	if not g_currentMission.missionDynamicInfo.isMultiplayer then
		color = Farm.COLOR_SINGLEPLAYER
		self.farmIcon:setImageFilename(productionStorageControl.emptyIcon)
	else
		self.farmIcon:setImageSlice(nil, Farm.ICON_SLICE_IDS[selectedFarm.color])
	end
	self.farmIDElement.textElement:setTextColor(color[1], color[2], color[3], color[4])
end


--Verpackungen hinterlegen abhänging vom FillType
function ProductionStorageDialog:setFillTypePackages(fillTypeIndex)
	local objectInfoTable = {}

	for num, objectInfo in pairs(self.selectedOption.packages) do
		if objectInfo.title ~= nil then
			table.insert(objectInfoTable, objectInfo.title)
			self.maxUnloadAmount = objectInfo.max

			if objectInfo.wrapped == true then
				self.changeColorButton:setVisible(true)
			else
				self.changeColorButton:setVisible(false)
			end
		end
	end

	self.fillTypePackageElement:setTexts(objectInfoTable)
	self.fillTypePackageElement:setState(1, true)
end


-- -1 Butten
function ProductionStorageDialog:onClickLeft1(element)
	self:updateAmount(-1)
end


-- -10 Butten
function ProductionStorageDialog:onClickLeft10()
	self:updateAmount(-10)
end


-- +1 Butten
function ProductionStorageDialog:onClickRight1()
	self:updateAmount(1)
end


-- +10 Butten
function ProductionStorageDialog:onClickRight10()
	self:updateAmount(10)
end


--Buttens anlegen
function ProductionStorageDialog:onCreateButten()

end


--Butten Eingabe verarbeiten
function ProductionStorageDialog:updateAmount(amount)
	local oldAmount = self.amountElement:getState()
	local newAmount = oldAmount + amount
	if oldAmount == 0 then
		newAmount = newAmount +1
	end
	if newAmount > self.maxUnloadAmount +1 then 
		newAmount = self.maxUnloadAmount +1
	end

	self.selectedAmount = newAmount
	self.amountElement:setState(self.selectedAmount, true)
end


--Farbmenue öffnen
function ProductionStorageDialog:onClickChangeColor()
	if #self.colors > 1 then
		local unlimited = false
		if g_modIsLoaded.FS25_unlimitedColorConfigurations then
			unlimited = true
		end
		local currentColor = self.selectedColor
		if self.currentColorIndex ~= nil then
			currentColor = nil
		end
		ColorPickerDialog.show(self.setFoilColor, self, nil, self.colors, self.currentColorIndex, "calibratedMatPaint", currentColor, unlimited, nil, false)
	end
end


--Folienfarbe ändern und hinterlegen wenn vorhanden
function ProductionStorageDialog:setFoilColor(selectedIndex, empty, selectedColor)
	if self.colors == nil then
		--Farben hinterlegen
		self.colors = {}

		local color = {name = g_i18n:getText("ui_colorWhite"), color = {0.8500, 0.8500, 0.8500}}
		table.insert(self.colors, color)
		local color = {name = g_i18n:getText("ui_colorBlack"), color = {0.0500, 0.0500, 0.0500}}
		table.insert(self.colors, color)
		local color = {name = g_i18n:getText("ui_colorPink"), color = {0.6662, 0.3839, 0.5481}}
		table.insert(self.colors, color)
		local color = {name = g_i18n:getText("ui_colorGreen"), color = {0.3910, 0.5210, 0.3660}}
		table.insert(self.colors, color)
		local color = {name = g_i18n:getText("ui_colorBlue"), color = {0.1845, 0.5520, 0.5972}}
		table.insert(self.colors, color)

		if g_modIsLoaded.FS25_unlimitedColorConfigurations then
			for _, configuration in pairs(PlaceableConfigurationItemColor.DEFAULT_COLORS) do
				local name, color = g_vehicleMaterialManager:getMaterialTemplateColorAndTitleByName(configuration)
				if name ~= nil then
					local entry = {}
					entry.name = color
					entry.color = name
					table.insert(self.colors, entry)
				end
			end
		end
	end

	if selectedColor ~= nil then
		self.selectedColor = selectedColor.customColor
		self.currentColorIndex = nil
	elseif selectedIndex ~= nil then
		self.currentColorIndex = selectedIndex
		self.selectedColor = self.colors[self.currentColorIndex].color
	end
	
	if self.selectedColor ~= nil then
		self.changeColorButtonImage:setImageColor(nil, self.selectedColor[1], self.selectedColor[2], self.selectedColor[3], 1)
	end
end