-- ============================================================================
-- === PersistentFactories.Lua
-- === Script by [LSMT] Modding Team 
-- === LS25 / FS25
-- === Script by [LSMT] BaTt3RiE @ 2025
-- === Multiplayer Support = True
-- === Ver 1.0.0.0
-- ============================================================================

PersistentFactories = {}

DEBUG = false

local function debugPrint(...)
    if DEBUG then
        print(...)
    end
end

PersistentFactories.allowedFactories = {
    "preplacedBakery",
	"preplacedCannedPackagedFactory",
	"preplacedCarpenter",
	"preplacedCementFactoryPlaceable",
	"preplacedCheeseFactory",
	"preplacedChocolateFactory",
	"preplacedClothFactory",
	"preplacedCocoaPress",
	"preplacedDairy",
	"preplacedDeliSaladProduction",
	"preplacedFeedFactory",
	"preplacedFertilizerFactory",
	"preplacedFrizzySpizzFactory",
	"preplacedGrainMill",
	"preplacedIceCreamFactory",
	"preplacedLimeMine",
	"preplacedOilPlantUS",
	"preplacedPalletFactory",
	"preplacedPotatoProcessingPlant",
	"preplacedPulpPlant",
	"preplacedRefinery",
    "preplacedRopeMakerUS",
	"preplacedSalineProcessing",
	"preplacedSaltMine",
	"preplacedSawmill",
	"preplacedSpinnery",
	"preplacedStrawProcessing",
	"preplacedSugarMill",
	"preplacedUpholsteredFurnitureFactory",
	"greenHouseGlassLargeChilli",
	"greenHouseGlassLargeGarlic",
	"greenHouseGlassLargeLettuce",
	"greenHouseGlassLargeNapaCabbage",
	"greenHouseGlassLargeSpringOnion",
	"greenHouseGlassLargeStrawberry",
	"greenHouseGlassLargeTomato",
	"bga500kw"
	
}

function PersistentFactories.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(PlaceableProductionPoint, specializations)
end

function PersistentFactories.isProtectedFactory(configFileName)
    for _, factoryName in ipairs(PersistentFactories.allowedFactories) do
        if configFileName:find(factoryName) then
            return true
        end
    end
    return false
end

function PersistentFactories.getSellAction(placeable)
    if placeable.configFileName and PersistentFactories.isProtectedFactory(placeable.configFileName) then
        debugPrint("DEBUG: Verkauf einer geschützten Fabrik erkannt – bleibt auf der Map!")
        return Placeable.SELL_AND_SPECTATOR_FARM
    end
    if PersistentFactories.oldGetSellAction then
        return PersistentFactories.oldGetSellAction(placeable)
    end
end

function PersistentFactories.removeProductionPoint(manager, productionPoint)
    if productionPoint.configFileName and PersistentFactories.isProtectedFactory(productionPoint.configFileName) then
        debugPrint("DEBUG: Geschützte Fabrik soll entfernt werden – Verhindert!")
        productionPoint:setOwnerFarmId(FarmManager.NO_OWNER)
        return
    end
    if PersistentFactories.oldRemoveProductionPoint then
        PersistentFactories.oldRemoveProductionPoint(manager, productionPoint)
    end
end

function PersistentFactories:onSell(productionPoint)
    if productionPoint and productionPoint.configFileName and PersistentFactories.isProtectedFactory(productionPoint.configFileName) then
        debugPrint("DEBUG: Verkauf einer geschützten Fabrik erkannt!")

        debugPrint("DEBUG: Setze Besitzer auf 'Niemand'.")
        productionPoint:setOwnerFarmId(FarmManager.NO_OWNER)

        if productionPoint.spec_productionPoint ~= nil then
            debugPrint("DEBUG: Produktion gefunden. Deaktiviere Produktion...")
            productionPoint.spec_productionPoint.productionPoint:setIsProductionEnabled(false)
        else
            debugPrint("DEBUG: WARNUNG: KEINE Produktion gefunden!")
        end

        g_currentMission.productionChainManager.reverseProductionPoint[productionPoint] = true
        table.insert(g_currentMission.productionChainManager.productionPoints, productionPoint)

        debugPrint("DEBUG: Fabrik wurde verkauft, aber bleibt auf der Karte!")
        return false
    end
end

function PersistentFactories.onLoad(placeable, savegame)
    debugPrint("DEBUG: PersistentFactories wurde geladen.")

    if not PersistentFactories.hooksSet then
        PersistentFactories.hooksSet = true

        if Placeable.getSellAction then
            debugPrint("DEBUG: Hook in getSellAction wird gesetzt.")
            PersistentFactories.oldGetSellAction = Placeable.getSellAction
            Placeable.getSellAction = PersistentFactories.getSellAction
        end

        if g_currentMission and g_currentMission.productionChainManager then
            debugPrint("DEBUG: Hook in removeProductionPoint wird gesetzt.")
            PersistentFactories.oldRemoveProductionPoint = g_currentMission.productionChainManager.removeProductionPoint
            g_currentMission.productionChainManager.removeProductionPoint = PersistentFactories.removeProductionPoint
        else
            debugPrint("DEBUG: WARNUNG: g_currentMission.productionChainManager nicht gefunden!")
        end
    end
end

PlaceableProductionPoint.onLoad = Utils.appendedFunction(PlaceableProductionPoint.onLoad, PersistentFactories.onLoad)
