-- ============================================================================
-- === AutoLiftAxle.Lua
-- === MOD my [LSMT] Modding Team
-- === LS25 / FS25
-- === Script by [LSMT] Modding Team @ 2025
-- === Ver 0.1.1.5 (Beta)
-- ============================================================================

AutoLiftAxle = {}

function AutoLiftAxle.prerequisitesPresent(specializations)
    return true
end

function AutoLiftAxle.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "setLiftAxleState", AutoLiftAxle.setLiftAxleState)
end

function AutoLiftAxle.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", AutoLiftAxle)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", AutoLiftAxle)  -- Force-Update nach vollständigem Laden
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", AutoLiftAxle)
    SpecializationUtil.registerEventListener(vehicleType, "onPostDetach", AutoLiftAxle)
    SpecializationUtil.registerEventListener(vehicleType, "onPostAttach", AutoLiftAxle)
    SpecializationUtil.registerEventListener(vehicleType, "onReadStream", AutoLiftAxle)
    SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", AutoLiftAxle)
end

function AutoLiftAxle:onLoad(savegame)
    --self.liftAxleActive = false
    self.liftAxleActive = true
    self.liftAxleCheckTimer = 0
    self.liftAxleCheckInterval = 2000
    self.shopStateApplied = false

    self.liftAxleDesign = 3
    if self.configurations ~= nil and self.configurations["design"] ~= nil then
        self.liftAxleDesign = tonumber(self.configurations["design"]) or 3
    end
end

-- Force-Update beim vollständigen Laden des Fahrzeugs
function AutoLiftAxle:onPostLoad(savegame)
    self:setLiftAxleState(self.liftAxleActive, false, true)
end

function AutoLiftAxle:onUpdate(dt)

    local isInShop = (g_gui.currentGuiName == "ShopConfigScreen")

    if isInShop and g_shopConfigScreen ~= nil then
        -- Prüfen, ob eigenes Vehicle = das Vehicle im Shop
        if g_shopConfigScreen.vehicle == self then
            -- NUR für dieses Fahrzeug im Shop die Achsen hochsetzen:
            self.liftAxleActive = true
            self.wasInShop = true

            -- Shop-Animation/Logik:
            if self.liftAxleDesign ~= 4 then
                if (self.liftAxleDesign == 1 or self.liftAxleDesign == 3)
                   and self:getAnimationExists("Animation_LiftAxle_Front") then
                    local direction = 1
                    self:playAnimation("Animation_LiftAxle_Front", direction, self:getAnimationTime("Animation_LiftAxle_Front"), true)
                end

                if (self.liftAxleDesign == 2 or self.liftAxleDesign == 3)
                   and self:getAnimationExists("Animation_LiftAxle_Back") then
                    local direction = 1
                    self:playAnimation("Animation_LiftAxle_Back", direction, self:getAnimationTime("Animation_LiftAxle_Back"), true)
                end
            end
            return
        end
    end

    -- Server-seitige Logik: Nur der Server berechnet den Hubachsen-Zustand
    if g_server then
        AutoLiftAxle.checkLiftAxleState(self, dt)
    end

end

function AutoLiftAxle.findMotorizedAttacherVehicle(vehicle)
    local currentVehicle = vehicle

    while currentVehicle ~= nil do
        if currentVehicle.getIsMotorStarted ~= nil then
            return currentVehicle
        end
        currentVehicle = currentVehicle:getAttacherVehicle()
    end

    return nil
end

function AutoLiftAxle.checkLiftAxleState(self, dt)
    local motorizedVehicle = AutoLiftAxle.findMotorizedAttacherVehicle(self)

    if motorizedVehicle == nil then
        self:setLiftAxleState(true) -- Lifachse unten
        return
    end

    local motorOn = motorizedVehicle:getIsMotorStarted()
    if motorOn then
        -- Den Timer fortlaufend erhöhen, ohne sofort raiseActive() aufzurufen
        self.liftAxleCheckTimer = self.liftAxleCheckTimer + dt
        if self.liftAxleCheckTimer >= self.liftAxleCheckInterval then
            self.liftAxleCheckTimer = 0



            local totalLoad = 0
            if self.spec_TrailerWeight.liftAxleThreshold then
                totalLoad = self.spec_TrailerWeight.currentWeight
            else
                -- Fallback: Summiere die FillUnits
                if self.spec_fillUnits and self.spec_fillUnits.fillUnits then
                    for i, _ in ipairs(self.spec_fillUnits.fillUnits) do
                        totalLoad = totalLoad + self:getFillUnitFillLevel(i)
                    end
                else
                    totalLoad = self:getFillUnitFillLevel(1)
                end
            end

            if totalLoad > self.spec_TrailerWeight.liftAxleThreshold then
                -- Gewicht überschritten: Achse runterfahren
                self:setLiftAxleState(true) -- Lifachse unten
            else
                -- Gewicht unterhalb der Grenze: Achse anheben
                self:setLiftAxleState(false) -- Lifachse oben
            end
        end
    else
        self:setLiftAxleState(true) -- Lifachse unten
    end
end


function AutoLiftAxle:onPostDetach(attacherVehicle, implementIndex)
    self:setLiftAxleState(true) -- Lifachse unten
end

-- Optionale Force-Update beim Ankuppeln
function AutoLiftAxle:onPostAttach(attacherVehicle, implementIndex)
    --DUmmy 
end

function AutoLiftAxle:setLiftAxleState(state, noEventSend, forceUpdate)
    if forceUpdate or self.liftAxleActive ~= state then
        self.liftAxleActive = state

        -- Nur der Server sendet das Event, um den Zustand zu synchronisieren
        if g_server and not noEventSend then
            AutoLiftAxleEvent.sendEvent(self, state)
        end

        if self.liftAxleDesign == 1 then
            if self:getAnimationExists("Animation_LiftAxle_Front") then
                local direction = state and -1 or 1
                self:playAnimation("Animation_LiftAxle_Front", direction, self:getAnimationTime("Animation_LiftAxle_Front"), true)
            end
        elseif self.liftAxleDesign == 2 then
            if self:getAnimationExists("Animation_LiftAxle_Back") then
                local direction = state and -1 or 1
                self:playAnimation("Animation_LiftAxle_Back", direction, self:getAnimationTime("Animation_LiftAxle_Back"), true)
            end
        elseif self.liftAxleDesign == 3 then
            if self:getAnimationExists("Animation_LiftAxle_Front") then
                local direction = state and -1 or 1
                self:playAnimation("Animation_LiftAxle_Front", direction, self:getAnimationTime("Animation_LiftAxle_Front"), true)
            end
            if self:getAnimationExists("Animation_LiftAxle_Back") then
                local direction = state and -1 or 1
                self:playAnimation("Animation_LiftAxle_Back", direction, self:getAnimationTime("Animation_LiftAxle_Back"), true)
            end
        elseif self.liftAxleDesign == 4 then
            -- Keine Animationen definiert
        end

        for _, wheel in ipairs(self.spec_wheels.wheels) do
            if wheel.liftAxle then
                wheel.hasGroundContact = not state
            end
        end
        self:raiseDirtyFlags(self.vehicleDirtyFlag)
    end
end

function AutoLiftAxle:onWriteStream(streamId, connection)
    -- Wir schreiben immer (Server-Seite):
    streamWriteBool(streamId, self.liftAxleActive)
end

function AutoLiftAxle:onReadStream(streamId, connection)
    -- Wir empfangen immer (Client-Seite):
    self.liftAxleActive = streamReadBool(streamId)
    self:setLiftAxleState(self.liftAxleActive, true, true)
end

-- Netzwerk-Event für die Synchronisation des Hubachsen-Zustands
AutoLiftAxleEvent = {}
AutoLiftAxleEvent_mt = Class(AutoLiftAxleEvent, Event)

function AutoLiftAxleEvent.emptyNew()
    local self = Event.new(AutoLiftAxleEvent_mt)
    return self
end

function AutoLiftAxleEvent.new(vehicle, state)
    local self = AutoLiftAxleEvent.emptyNew()
    self.vehicle = vehicle
    self.state = state
    return self
end

function AutoLiftAxleEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.state = streamReadBool(streamId)
    self:run(connection)
end

function AutoLiftAxleEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteBool(streamId, self.state)
end

function AutoLiftAxleEvent:run(connection)
    if self.vehicle then
        self.vehicle:setLiftAxleState(self.state, true)
        if not connection:getIsServer() then
            g_server:broadcastEvent(self, false)
        end
    end
end

function AutoLiftAxleEvent.sendEvent(vehicle, state)
    if g_server then
        g_server:broadcastEvent(AutoLiftAxleEvent.new(vehicle, state), nil, nil, vehicle)
    else
        g_client:getServerConnection():sendEvent(AutoLiftAxleEvent.new(vehicle, state))
    end
end

InitEventClass(AutoLiftAxleEvent, "AutoLiftAxleEvent")
