MissionsTimes = {};
MissionsTimes.modDir = g_currentModDirectory;
source(MissionsTimes.modDir.."MissionsTimesEvent.lua");
function getAreas() --by hours !
	local fieldAreas = {
		FIELD_SIZE_NO 	 = {0,true};
		FIELD_SIZE_NOMOD = {0,true};
		FIELD_SIZE_0     = {0,true};
		FIELD_SIZE_4     = {24,true};
		FIELD_SIZE_9     = {48,true};
		FIELD_SIZE_15    = {72,true};
		FIELD_SIZE_25    = {96,true};
		FIELD_SIZE_40    = {120,true};
		FIELD_SIZE_50    = {144,true};
		FIELD_SIZE_55    = {144,false};
	};
	return fieldAreas;
end;
--------------------------------------------------optional edit here--------------------------------------------------
MissionsTimes.values = {	
	FIELD_SIZE_NONEMOD = {0,1,true};
	FIELD_SIZE_NONE = {0,0,true};
	FIELD_SIZE_BIGSMALL = {0,0,true}; 
	FIELD_SIZE_SMALL = {4,1,true}; --{field area size,default end day+day is running/active,deactivated time missions is field area size(running/active) >= field area then set *false*} 
	FIELD_SIZE_MEDIUM = {9,2,true}; 
	FIELD_SIZE_LARGE1 = {15,3,true}; 
	FIELD_SIZE_LARGE2 = {25,4,true};
	FIELD_SIZE_LARGE3 = {35,5,true};
	FIELD_SIZE_LARGE4 = {45,6,true};
	FIELD_SIZE_BIGLARGE = {50,7,false};	--running time limit off (false)
	
	TIMEMISSIONS = true; --deactivated all running time missions set *false* ! Attention ! Missions will then remain in the task list unlimited
	
	areas = getAreas();
	
	minHours = {4}; --force min. hours by IngameDayTime (min. max ~3-30) day+1+daytime
		
	lsTextColor = {0.89627, 0.92158, 0.81485, 1}; --default
	warningColor60 = {255/255, 255/255, 0/255, 1}; --yellow by MD Mod
	warningColor30 = {255/255, 55/255, 0/255, 1}; --orangeRed by MD Mod			
	notActiveColor = {240/255, 230/255, 140/255, 1}; --khaki by _hlUtils Script
	activeColor = {118/255, 185/255, 0/255, 1}; --ls25 gamecolor by _hlUtils Script
	viewProgressBarTimes = true; --on/off function... respect for other Mods --> g_currentMission.hlUtils.globalFunction["FS25_MissionsTimes"].setViewProgressBarTimes(false) !check before is hlUtils ready! or own function
	viewProgressBarClick = true; --on/off function... respect for other Mods --> g_currentMission.hlUtils.globalFunction["FS25_MissionsTimes"].setViewProgressBarClick(false) !check before is hlUtils ready! or own function
};
--------------------------------------------------optional edit here--------------------------------------------------




MissionsTimes.metadata = {
	interface = "FS25 ...", --new ls25
	title = "Missions Times",
	notes = "Dieser Mod setzt neue Missionszeiten auf Feldern oder deaktivert diese. Alternativ können die Missionszeiten auch für alle Missionen deaktivert werden.",
	author = "(by HappyLooser)",
	version = "1.0.0.1",	
	build = 13,
	isMpReady = true,
	datum = "23.02.2025",
	update = "24.05.2025",	
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};	

function MissionsTimes:loadMap(name)
	print("---loading ".. tostring(MissionsTimes.metadata.title).. " ".. tostring(MissionsTimes.metadata.version).. "(#".. tostring(MissionsTimes.metadata.build).. ") ".. tostring(MissionsTimes.metadata.author).. "---")
	MissionsTimes:abstractMissionStart();
	MissionsTimes.otherMods = {missionsDisplay=false,hlHudSystem=false};
	if not MissionsTimes:getDetiServer() then Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, MissionsTimes.onStartMission);end;	
end; 

function MissionsTimes:onStartMission()
	if MissionsTimes:getDetiServer() then return;end;
	MissionsTimes:createdAtrributes();	
	if g_currentMission.hlUtils ~= nil then
		MissionsTimes.otherMods.hlHudSystem = g_currentMission.hlHudSystem ~= nil;
		MissionsTimes.otherMods.missionsDisplay = g_currentMission.hlUtils.modLoaded["FS25_MissionsDisplay"] ~= nil and g_currentMission.hlUtils.globalFunction["FS25_MissionsDisplay"].viewProgressBars ~= nil;
		g_currentMission.hlUtils.modLoad("FS25_MissionsTimes");
		MissionsTimes:setGlobalFunction();		
	end;
end;

function MissionsTimes:delete()
end;
---------------------------------------------------------------------------------------------
---time missions---
function getEndDayTime(hours)
	local hour = hours or 24;
	return hour*60*60*1000;
end;

function MissionsTimes:getMonoticDay(endDay, equals) --on testing	
	if equals then		
		
	else
		
	end;
	return endDay;
end;

function MissionsTimes:getFieldTyp(area)
	local fieldTyp = nil;
	if area ~= nil then
		if area >= MissionsTimes.values.FIELD_SIZE_BIGSMALL[1] then
			if area < MissionsTimes.values.FIELD_SIZE_SMALL[1] then 
				fieldTyp = "FIELD_SIZE_BIGSMALL";
			elseif area < MissionsTimes.values.FIELD_SIZE_MEDIUM[1] then 
				fieldTyp = "FIELD_SIZE_SMALL";
			elseif area >= MissionsTimes.values.FIELD_SIZE_MEDIUM[1] and area < MissionsTimes.values.FIELD_SIZE_LARGE1[1] then
				fieldTyp = "FIELD_SIZE_MEDIUM";
			elseif area >= 	MissionsTimes.values.FIELD_SIZE_LARGE1[1] and area < MissionsTimes.values.FIELD_SIZE_LARGE2[1] then
				fieldTyp = "FIELD_SIZE_LARGE1";
			elseif area >= 	MissionsTimes.values.FIELD_SIZE_LARGE2[1] and area < MissionsTimes.values.FIELD_SIZE_LARGE3[1] then
				fieldTyp = "FIELD_SIZE_LARGE2";
			elseif area >= 	MissionsTimes.values.FIELD_SIZE_LARGE3[1] and area < MissionsTimes.values.FIELD_SIZE_LARGE4[1] then
				fieldTyp = "FIELD_SIZE_LARGE3";			
			elseif area >= 	MissionsTimes.values.FIELD_SIZE_LARGE4[1] and area < MissionsTimes.values.FIELD_SIZE_BIGLARGE[1] then
				fieldTyp = "FIELD_SIZE_LARGE4";
			elseif area >= MissionsTimes.values.FIELD_SIZE_BIGLARGE[1] then
				fieldTyp = "FIELD_SIZE_BIGLARGE";
			end;
		end;	
	end;
	return fieldTyp;
end;

function MissionsTimes:getEndDateRunning(mission, day, dayTime, preview)
	if mission ~= nil then
		if mission.field ~= nil and mission.field.getAreaHa ~= nil then		
			local areaTyp = MissionsTimes:getFieldTyp(mission.field:getAreaHa());
			if areaTyp ~= nil then
				if not MissionsTimes.values[areaTyp][3] then return false;end;				
				local newDay = MissionsTimes.values[areaTyp][2]; 
				
				if preview and newDay == 0 then return true, day;end;				
				
				local dayTimeDelta = g_currentMission.environment:getEnvironmentTime();
				if newDay == 0 and dayTimeDelta > 23-MissionsTimes.values.minHours[1] then 
					newDay = MissionsTimes:getMonoticDay(1, false);
				end;				
				newDay = MissionsTimes:getMonoticDay(day+newDay, true);					
				return true, newDay;
			end;		
		else
			local areaTyp = "FIELD_SIZE_NONE";
			if mission.customEnvironment ~= nil and string.find(mission.customEnvironment, "FS25_") then --Mod !
				areaTyp = "FIELD_SIZE_NONEMOD";	
			end;			
			if not MissionsTimes.values[areaTyp][3] then return false;end;				
			local newDay = MissionsTimes.values[areaTyp][2];
			
			if preview and newDay == 0 then return true, day;end;	
			
			local dayTimeDelta = g_currentMission.environment:getEnvironmentTime();		
			if newDay == 0 and dayTimeDelta > 23-MissionsTimes.values.minHours[1] then 
				newDay = MissionsTimes:getMonoticDay(1, false);
			end;						
			newDay = MissionsTimes:getMonoticDay(day+newDay, true);			
			return true, newDay;
		end;
	end;
	return true, day;
end;

function MissionsTimes:getEndDateNotRunning(day, dayTime, typ)
	local newDay = g_currentMission.environment.currentMonotonicDay; --day;
	local newDayTime = dayTime;	
	local nextDay = 0;
	local isHour = g_currentMission.environment.currentHour+MissionsTimes.values.minHours[1];
	if isHour >= 23 or isHour == 0 or isHour >= 23-MissionsTimes.values.minHours[1] then nextDay = 1;isHour = 1;end;
	local maxHour = 23-isHour;
	if maxHour <= 0 or nil or isHour <= 0 or nil or maxHour > 23 or maxHour < isHour then maxHour = 18;isHour = 10;end; --fix random hours (safety)
	--random time--
	--math.randomseed(12345);		
	local hours = math.random(isHour, maxHour); --fix random
	newDayTime = getEndDayTime(hours)-1;	
	--random time--		
	--fix day (safety)--
	if nextDay == 0 and g_currentMission.environment.dayTime+newDayTime > getEndDayTime()-1 then		
		nextDay = MissionsTimes:getMonoticDay(1, false);	
	elseif nextDay == 0 and newDayTime < g_currentMission.environment.dayTime then 
		nextDay = MissionsTimes:getMonoticDay(1, false);	
	end;
	--fix day (safety)--
	--check season days/growth state--
	if typ ~= nil and typ.name ~= nil and (typ.name:lower() == "harvestmission" or typ.name:lower() == "chaffmission" or string.find(typ.name:lower(), "harvest") or string.find(typ.name:lower(), "chaff")) then
		if g_currentMission.environment.daysPerPeriod - g_currentMission.environment:getDayInPeriodFromDay(newDay+nextDay) <= 0 or day == newDay then return day, dayTime;end;
	end;
	--check season days/growth state--
	return newDay+nextDay, newDayTime;
end;

function MissionsTimes:getMinutesRunning(endDate)    
    local environment = g_currentMission.environment;
    local currentMonotonicDay = environment.currentMonotonicDay;
    local dayTime = environment.dayTime;
    local totalDayTime = getEndDayTime();
    local endDay = endDate.endDay;
    local endDayTime = endDate.endDayTime;
    local dayTimeDelta = 0;
    
	if endDay > currentMonotonicDay then
		if endDayTime < dayTime then
			dayTimeDelta = endDayTime + (totalDayTime - dayTime);
			currentMonotonicDay = currentMonotonicDay + 1;
		else
			dayTimeDelta = endDayTime - dayTime;
		end;		
		dayTimeDelta = dayTimeDelta + (endDay - currentMonotonicDay) * totalDayTime;		
		local minutesLeft = dayTimeDelta / (1000 * 60);
		return minutesLeft/60;
	else
		if endDayTime > dayTime then
			dayTimeDelta = endDayTime - dayTime;
		elseif currentMonotonicDay < endDay then
			dayTimeDelta = dayTime - endDayTime;
			
			dayTimeDelta = dayTime + (totalDayTime - endDayTime);
			currentMonotonicDay = currentMonotonicDay + 1;
		end;
		dayTimeDelta = dayTimeDelta + (endDay - currentMonotonicDay) * totalDayTime;
		local minutesLeft = dayTimeDelta / (1000 * 60);
		return minutesLeft/60;
	end;
end;

function MissionsTimes:getMinutesLeft()
    local endDate = self.endDate;
    if endDate == nil then
        return nil;
    end;    
    local environment = g_currentMission.environment;
    local currentMonotonicDay = environment.currentMonotonicDay;
    local dayTime = environment.dayTime;
    local totalDayTime = getEndDayTime();

    local endDay = endDate.endDay;
    local endDayTime = endDate.endDayTime;
	local dayTimeDelta = 0;
	
	if endDay > currentMonotonicDay then
		if endDayTime < dayTime then
			dayTimeDelta = endDayTime + (totalDayTime - dayTime);
			currentMonotonicDay = currentMonotonicDay + 1;
		else
			dayTimeDelta = endDayTime - dayTime;
		end;		
		dayTimeDelta = dayTimeDelta + (endDay - currentMonotonicDay) * totalDayTime;		
		local minutesLeft = dayTimeDelta / (1000 * 60);
		return minutesLeft;
	else		
		if endDayTime > dayTime then			
			dayTimeDelta = endDayTime - dayTime;			
		elseif currentMonotonicDay < endDay then			
			dayTimeDelta = dayTime + (totalDayTime - endDayTime);						
			currentMonotonicDay = currentMonotonicDay + 1;		
		end;
		dayTimeDelta = dayTimeDelta + (endDay - currentMonotonicDay) * totalDayTime;
		local minutesLeft = dayTimeDelta / (1000 * 60);
		return minutesLeft;
	end;    
end;
AbstractMission.getMinutesLeft = Utils.overwrittenFunction(AbstractMission.getMinutesLeft, MissionsTimes.getMinutesLeft);

function MissionsTimes:getTextWrap(progressBar, textMaxWidth, textSize)
	local title = progressBar.title == nil and "" or utf8ToUpper(progressBar.title.. (progressBar.text == nil and "" or ": "));
	local text = progressBar.text == nil and "" or utf8ToUpper(progressBar.text);
	local textWidth = getTextWidth(textSize, text);
	local titleWidth = getTextWidth(textSize, title);
	return textMaxWidth - titleWidth;	
end;

function MissionsTimes:getTextHeightMultiple(progressBar)
	local textHeight = 0;	
	if progressBar.sellingStationName ~= nil and g_i18n:getText("contract_details_harvesting_sellingStation") ~= nil then
		textHeight = textHeight+1;
	end;
	if progressBar.deliveredTitle ~= nil and progressBar.deliveredText ~= nil then textHeight = textHeight+1;end;
	return textHeight;
end;

function MissionsTimes:isOtherMod(progressBar, contractText)	
	return progressBar.textExtension ~= nil or progressBar.deliveredTitle ~= nil or progressBar.baleTypeTitle ~= nil or progressBar.sellingStationName ~= nil or string.find(progressBar.title, contractText);
end;

function MissionsTimes:drawProgressBars()
	if MissionsTimes.values.viewProgressBarTimes then
		local dropRunningMinutes = not MissionsTimes.otherMods.missionsDisplay or (MissionsTimes.otherMods.missionsDisplay and g_currentMission.hlUtils.globalFunction["FS25_MissionsDisplay"].viewProgressBars());
		if self ~= nil and self.progressBars ~= nil and dropRunningMinutes then
			if (self.setRunningWidth == nil or self.orgTextSize == nil) or (self.orgTextSize ~= self.progressBarProgressTextSize) then self.setRunningWidth = getTextWidth(self.progressBarProgressTextSize, "--:--");self.textMaxWidth = self.textMaxWidth - self.setRunningWidth;self.orgTextSize = self.progressBarProgressTextSize;end; --first or new uiScale
			local contractText = g_i18n:getText("contract_title");
			local posX, posY = self:getPosition();
			local int = 1;
			if MissionsTimes.hlHudSystem then g_currentMission.hlHudSystem.clickAreas["MissionsTimes_progressBarAreas"] = {};end;
			for _, progressBar in ipairs(self.progressBars) do
				if progressBar.isVisible then
					if progressBar.title ~= nil and progressBar.title:len() > 0 and (progressBar.title == contractText or MissionsTimes:isOtherMod(progressBar, contractText)) then 					
						local textMultiple = MissionsTimes:getTextHeightMultiple(progressBar, self.textMaxWidth, self.progressBarTextSize);
						local nextPosY = posY - self.notificationOffsetY;					
						if progressBar.runningColor ~= nil then setTextColor(unpack(progressBar.runningColor));end;
						local textPosY = nextPosY + self.progressBarTitleOffsetY;
						if int > 1 and textMultiple > 0 then textPosY = textPosY - (self.notificationOffsetY*(textMultiple));end;						
						setTextAlignment(RenderText.ALIGN_RIGHT);
						setTextBold(true);
						renderText(posX + self.progressBarProgressTextOffsetX, textPosY, self.progressBarProgressTextSize, progressBar.runningMinutes);
						setTextBold(false);
						setTextAlignment(0);
						setTextColor(1, 1, 1, 1);
						local text = progressBar.text == nil and "" or utf8ToUpper(progressBar.text);						
						setTextWrapWidth(MissionsTimes:getTextWrap(progressBar, self.textMaxWidth, self.progressBarTextSize))
						local textHeight = getTextHeight(self.progressBarTextSize, text);						
						setTextWrapWidth(0);
						local height = (textHeight + self.textOffsetY * 2 + self.barHeight)+(textHeight*textMultiple);
						if MissionsTimes.otherMods.hlHudSystem and MissionsTimes.values.viewProgressBarClick then
							local areaX = self.progressBarBgTop.x + self.progressBarTitleOffsetX
							local clickArea = {x=areaX,x1=areaX+self.textMaxWidth,y=posY-height,y1=posY};
							local inArea = g_currentMission.hlUtils.mouseIsInArea(nil, nil, clickArea.x, clickArea.x1, clickArea.y, clickArea.y1);							
							if not g_currentMission.hlUtils:disableInArea() and inArea then g_currentMission.hlHudSystem:setClickArea( {clickArea.x, clickArea.x1, clickArea.y, clickArea.y1, onClick=MissionsTimes.onClickArea, whatClick="MissionsTimes_progressBarAreas", whereClick="clickProgressBar_", ownTable={missionId=progressBar.missionId}} );end;
						end;						
						posY = nextPosY - height;						
						int = int+1;
					end;
				end;
			end;
		end;
	end;
end;

function MissionsTimes:updateProgressBars(dt)
	if MissionsTimes.values.viewProgressBarTimes then
		if self ~= nil and (self.status == MissionStatus.RUNNING or self.status == MissionStatus.FINISHED) then
			if g_localPlayer ~= nil and g_localPlayer.farmId == self.farmId then
				local dropRunningMinutes = not MissionsTimes.otherMods.missionsDisplay or (MissionsTimes.otherMods.missionsDisplay and g_currentMission.hlUtils.globalFunction["FS25_MissionsDisplay"].viewProgressBars());
				if self.progressBar ~= nil and dropRunningMinutes then					
					if self.progressBar ~= nil and self.progressBar.orgText == nil and self.progressBar.text ~= nil and self.progressBar.text:len() > 2 then self.progressBar.orgText = self.progressBar.text;end;
					if self.progressBar.updateMinutes == nil or self.progressBar.updateMinutes then
						local runningMinutes = nil;
						if self.endDate ~= nil then runningMinutes = self:getMinutesLeft();end; --MissionsTimes:getRunningMinutes(self, self.endDate.endDay, self.endDate.endDayTime);end;
						local textColor = MissionsTimes.values.notActiveColor;
						local runningText = nil;
						if runningMinutes == nil then						
							runningText = g_i18n:getText("ui_hours_none"); --no limit running mission
							self.progressBar.updateMinutes = false;
						else								
							if runningMinutes < 30 then textColor = MissionsTimes.values.warningColor30;elseif runningMinutes < 60 then textColor = MissionsTimes.values.warningColor60;end;					
							runningText = g_i18n:formatMinutes(runningMinutes);
							self.progressBar.updateMinutes = true;
						end;
						self.progressBar.runningColor = textColor;						
						self.progressBar.runningMinutes = runningText;										
						
						self.progressBar.missionId = self.id;
					end;				
				end;
			end;
		end;	
	end;
end;

function MissionsTimes:abstractMissionStart()	
	oldAbstractMissionStart = AbstractMission.start;
	AbstractMission.start = function(self, spawnVehicles)
		local isOkay, result = pcall(oldAbstractMissionStart, self, spawnVehicles)
		if isOkay and self ~= nil then
			if g_currentMission.missionDynamicInfo.isMultiplayer then
				if (MissionsTimes:getDetiServer() or MissionsTimes:getHostOrSp()) and MissionsTimes.metadata.isMpReady then
					MissionsTimes:setRunningEndDate(self, "MissionsTimes:start MP");
					self:raiseActive();
					g_server:broadcastEvent(MissionsTimesEvent.new(self));
				end;
			else
				MissionsTimes:setRunningEndDate(self, "MissionsTimes:start SP");
			end;
			return result;
		end;
	end;
	SideNotification.draw = Utils.prependedFunction(SideNotification.draw, MissionsTimes.drawProgressBars);
	AbstractMission.update = Utils.appendedFunction(AbstractMission.update, MissionsTimes.updateProgressBars);
end;

function MissionsTimes:populateCellForItemInSection(page, pageIndex, contractId, contractPage)
	if page ~= self.detailsList then
		local contract = self.sectionContracts[self.subCategorySelector:getState()][pageIndex].contracts[contractId]
		local mission = contract.mission
		if mission ~= nil then			
			local timeLimit = contractPage:getAttribute("time");
			local minutes = mission:getMinutesLeft();
			local field = contractPage:getAttribute("field");
			local activeTime = contractPage:getAttribute("activeTime");			
			if not contract.finished and not contract.isPreparing and mission.status == MissionStatus.CREATED then				
				if timeLimit ~= nil and timeLimit.sourceText ~= nil then
					local textColor = MissionsTimes.values.notActiveColor;
					if minutes ~= nil then				
						if minutes < 30 then textColor = MissionsTimes.values.warningColor30;elseif minutes < 60 then textColor = MissionsTimes.values.warningColor60;end;
					end;
					timeLimit.textColor = textColor;					
					timeLimit.sourceText = timeLimit.sourceText.. "\n ";
					timeLimit.textMaxNumLines = 2;					
				end;
				local hectatText = nil;
				if field ~= nil and field.sourceText ~= nil then								
					if mission.field ~= nil and mission.field.getAreaHa ~= nil then						
						hectarText = g_i18n:formatArea(mission.field:getAreaHa(), 2);
						field.sourceText = field.sourceText.. "\n".. hectarText;
					else
						field.sourceText = field.sourceText.. "\n ";						
					end;
					field.textMaxNumLines = 2;					
					field.textUpperCase = false;
				end;
				if activeTime ~= nil and activeTime.sourceText ~= nil then
					local runningMinutes = nil;
					if mission.endDate ~= nil then runningMinutes = MissionsTimes:getRunningMinutes(mission, mission.endDate.endDay, mission.endDate.endDayTime);end;
					activeTime.textColor = MissionsTimes.values.activeColor;
					if runningMinutes == nil then						
						activeTime:setText(" \n* ".. g_i18n:getText("ui_hours_none")); --no limit running mission						
					else 
						local dropRunningMinutes = math.ceil(runningMinutes) ~= math.ceil(minutes);						
						if dropRunningMinutes then
							activeTime:setText(" \n* ".. g_i18n:formatMinutes(runningMinutes));						
						else
							activeTime:setText(" \n ");
						end;
					end;					
					activeTime.textMaxNumLines = 2;
					activeTime:setVisible(true);
				end;
			elseif (contract.finished or mission.status == MissionStatus.RUNNING) then
				if field ~= nil and field.sourceText ~= nil then field.textMaxNumLines = 1;end;							
				local textColor = MissionsTimes.values.notActiveColor;
				if minutes ~= nil then				
					if minutes < 30 then textColor = MissionsTimes.values.warningColor30;elseif minutes < 60 then textColor = MissionsTimes.values.warningColor60;end;
				end;
				if timeLimit ~= nil then timeLimit.textColor = textColor;end;
				if activeTime ~= nil then activeTime:setVisible(false);end;
			else
				if field ~= nil and field.sourceText ~= nil then field.textMaxNumLines = 1;end;							
				if timeLimit ~= nil then timeLimit.textColor = MissionsTimes.values.notActiveColor;end;
				if activeTime ~= nil then activeTime:setVisible(false);end;
			end;
		end;	
	end;	
end;
InGameMenuContractsFrame.populateCellForItemInSection = Utils.appendedFunction(InGameMenuContractsFrame.populateCellForItemInSection, MissionsTimes.populateCellForItemInSection);

function MissionsTimes:updateDetailContents(pageIndex, contractId)
	local contractDetails = self.sectionContracts[self.subCategorySelector:getState()][pageIndex]
	if contractDetails ~= nil then
		local selectMission = contractDetails.contracts[contractId]
		if selectMission ~= nil and selectMission.mission ~= nil then
			local mission = selectMission.mission;
			if not selectMission.finished and not self.currentContract.isPreparing then
				if MissionsTimes.contractDetails.activeTime ~= nil then					
					local textColor = MissionsTimes.values.notActiveColor;
					local runningMinutes = nil;					
					local runningText = "";
					local runningTextInfo = "";
					if mission.status == MissionStatus.RUNNING then 
						runningText = g_i18n:getText("ui_pendingMissionTimeLeftTitle").. ": ";
						runningTextInfo = " (".. g_i18n:getText("contract_title").. ")";
						if mission.endDate ~= nil then runningMinutes = mission:getMinutesLeft();end;
					else 
						runningText = g_i18n:getText("ui_ingameMissionTimeLimit").. ": ";
						runningTextInfo = " (".. g_i18n:getText("contract_title").. "/".. g_i18n:getText("contract_active").. ")";
						if mission.endDate ~= nil then runningMinutes = MissionsTimes:getRunningMinutes(mission, mission.endDate.endDay, mission.endDate.endDayTime);end;
					end;					
					
					if runningMinutes == nil then						
						runningText = runningText.. g_i18n:getText("ui_no").. runningTextInfo; --no limit running mission						
					else 								
						if runningMinutes < 30 then textColor = MissionsTimes.values.warningColor30;elseif runningMinutes < 60 then textColor = MissionsTimes.values.warningColor60;end;
						runningText = runningText.. g_i18n:formatMinutes(runningMinutes).. runningTextInfo;						
					end;	
					MissionsTimes.contractDetails.activeTime.textColor = textColor;
					MissionsTimes.contractDetails.activeTime:setText(runningText)
					MissionsTimes.contractDetails.activeTime:setVisible(true);					
				end;
			else
				if MissionsTimes.contractDetails.activeTime ~= nil then	MissionsTimes.contractDetails.activeTime:setVisible(false);end;
			end;
		else
			if MissionsTimes.contractDetails.activeTime ~= nil then	MissionsTimes.contractDetails.activeTime:setVisible(false);end;
		end;
	else
		if MissionsTimes.contractDetails.activeTime ~= nil then	MissionsTimes.contractDetails.activeTime:setVisible(false);end;
	end;
end;
InGameMenuContractsFrame.updateDetailContents = Utils.appendedFunction(InGameMenuContractsFrame.updateDetailContents, MissionsTimes.updateDetailContents)

function MissionsTimes:createdAtrributes()
	local runningTime = g_inGameMenu.pageContracts.contractsList.cellDatabase.autoCell1:getDescendantByName("time");
	local activeTime = runningTime:clone(g_inGameMenu.pageContracts.contractsList.cellDatabase.autoCell1);
	activeTime.name = "activeTime";	
	activeTime:applyProfile("fs25_contractsListItemTime");
	activeTime.textColor = MissionsTimes.values.activeColor;
	activeTime.textBold = false;
	activeTime:setVisible(true);
	
	MissionsTimes.contractDetails = {};
	local activeTimeDetails = g_inGameMenu.pageContracts.titleText:clone(g_inGameMenu.pageContracts);	
	activeTimeDetails.name = "activeTimeDetails";
	local textSize = activeTimeDetails.textSize;
	activeTimeDetails:setPosition(nil, -35/1440 *g_aspectScaleY); --268/2560 *g_aspectScaleX
	activeTimeDetails:applyProfile("fs25_contractsContractTitle");	
	--activeTimeDetails.textMaxNumLines = 2;
	--activeTimeDetails.textAlignment = 0;
	activeTimeDetails.textBold = true;
	activeTimeDetails.textSize = textSize/1.4;
	activeTimeDetails.defaultTextSize = textSize/1.4;	
	activeTimeDetails:setVisible(false);	
	MissionsTimes.contractDetails.activeTime = activeTimeDetails;	
end;

function MissionsTimes:registerMission(mission, typ)	
	local canRegisterMission = not g_currentMission.missionDynamicInfo.isMultiplayer or (g_currentMission.missionDynamicInfo.isMultiplayer and (MissionsTimes:getDetiServer() or MissionsTimes:getHostOrSp()) and MissionsTimes.metadata.isMpReady);
	if canRegisterMission and mission ~= nil then
		local endDay = nil;
		local endDayTime = nil;
		if mission.endDate ~= nil then			
			
			endDay = mission.endDate.endDay;
			endDayTime = mission.endDate.endDayTime;				
			local newDay, newDayTime = MissionsTimes:getEndDateNotRunning(endDay, endDayTime, typ);
			mission:setEndDate(newDay, newDayTime);
			
		end;		
		--print("###registerMission: typ:".. tostring(typ.name).. " /old endDay: ".. tostring(endDay).. " /old endDayTime: ".. tostring(endDayTime))
		--if mission.endDate ~= nil then print("###registerMission: typ:".. tostring(typ.name).. " /new endDay: ".. tostring(mission.endDate.endDay).. " /new endDayTime: ".. tostring(mission.endDate.endDayTime));else print("###registerMission: typ:".. tostring(typ.name).. " /new endDay: --:--");end;
	end;	
end;
MissionManager.registerMission = Utils.prependedFunction(MissionManager.registerMission, MissionsTimes.registerMission);
---time missions---

function MissionsTimes:setRunningEndDate(mission, what)	
	if mission ~= nil then 
		local endDay = nil;
		local endDayTime = nil;
		if mission.endDate ~= nil then			
			if not MissionsTimes.values.TIMEMISSIONS then 
				mission.endDate = nil;
			else		
				endDay = mission.endDate.endDay
				endDayTime = mission.endDate.endDayTime
				local timeLimit, newDay = MissionsTimes:getEndDateRunning(mission, endDay, endDayTime, false);
				if not timeLimit then 
					mission.endDate = nil;
				elseif newDay ~= nil then
					mission.endDate.endDay = newDay;					
				end;
			end;
		end;
		--print("###setRunningEndDate: typ:".. tostring(mission.type.name).. " /old endDay: ".. tostring(endDay).. " /old endDayTime: ".. tostring(endDayTime))
		--if mission.endDate ~= nil then print("###setRunningEndDate: typ:".. tostring(mission.type.name).. " /new endDay: ".. tostring(mission.endDate.endDay).. " /new endDayTime: ".. tostring(mission.endDate.endDayTime));else print("###setRunningEndDate: typ:".. tostring(mission.type.name).. " /new endDay: --:--");end;
	end;
end;

function MissionsTimes:getRunningMinutes(mission, endDay, endDayTime)
	local timeLimit, newDay = MissionsTimes:getEndDateRunning(mission, endDay, endDayTime, true);
	if timeLimit and newDay ~= nil then
		
		return MissionsTimes:getMinutesRunning( {endDay=newDay, endDayTime=endDayTime} )*60;
	end;
	return nil;
end;

function MissionsTimes:setGlobalFunction()
	g_currentMission.hlUtils.globalFunction["FS25_MissionsTimes"] = {
		getRunningMinutes = function(mission, endDay, endDayTime)return MissionsTimes:getRunningMinutes(mission, endDay, endDayTime);end;
		isMpReady = function()return MissionsTimes.metadata.isMpReady;end;
		setViewProgressBarTimes = function(state)MissionsTimes.values.viewProgressBarTimes=state;end;
		setViewProgressBarClick = function(state)MissionsTimes.values.viewProgressBarClick=state;end;
	};	
end;
---------------------------------------------------------------------------------------------
addModEventListener(MissionsTimes);

function MissionsTimes:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function MissionsTimes:getHostOrSp()	
	return (g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil) or (not g_currentMission.missionDynamicInfo.isMultiplayer); --only mp host player or single player
end;

--needs HL Hud System--
function MissionsTimes.onClickArea(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil or args.clickAreaTable.ownTable == nil then return;end;	
	if args.isDown then
		if g_currentMission.hlUtils.dragDrop.on then return;end;
		if args.button == Input.MOUSE_BUTTON_LEFT then
			if args.clickAreaTable.whereClick == "clickProgressBar_" then
				local missionId = args.clickAreaTable.ownTable.missionId;
				if missionId ~= nil then
					if g_currentMission.hlUtils.getPlayerFarmId() == 0 then g_currentMission.hlHudSystem.showInfoBox( {g_i18n:getText("warning_joinFarmFirst"), 2500, g_currentMission.hlUtils.getColor("orangeRed", true)} );return;end;
					MissionsTimes:showInGameMenuFrame("ingameMenuContracts", missionId, false, 0, true);
				end;
			end;
		elseif args.button == Input.MOUSE_BUTTON_RIGHT then
			if args.clickAreaTable.whereClick == "clickProgressBar_" then
				local missionId = args.clickAreaTable.ownTable.missionId;
				if missionId ~= nil then
					MissionsTimes:setContractInfo(missionId);
				end;
			end;
		end;
	end;
end;

function MissionsTimes:setContractInfo(missionId) --by MissionsDisplay Mod
	local mission = MissionsTimes:getMissionById(missionId);
	if mission ~= nil then
		local playerPos = false;
		local stationName = nil;
		local foundFieldOrFarmland = {0,1};
		local foundSellPointOrSellingStation = {0,0};
		local distance = -1;
		if mission.sellingStation ~= nil and mission.sellingStation.getName ~= nil then
            stationName = mission.sellingStation:getName();
			foundSellPointOrSellingStation[2] = Utils.getNoNil(mission.sellingStation.rootNode, 0);
        elseif mission.sellPoint ~= nil and mission.sellPoint.getName ~= nil then
			stationName = mission.sellPoint:getName();
			foundSellPointOrSellingStation[1] = Utils.getNoNil(mission.sellPoint.rootNode, 0);
		end;
		if mission.field ~= nil and mission.field.getName ~= nil then
			foundFieldOrFarmland[1] = tonumber(mission.field:getName());				
		elseif mission.farmlandId ~= nil and mission.farmlandId > 0 then
			foundFieldOrFarmland[1] = mission.farmlandId;
			foundFieldOrFarmland[2] = 2;
		else
			foundFieldOrFarmland[1] = 1;
			foundFieldOrFarmland[2] = 3;
		end;
		if foundFieldOrFarmland[1] > 0 then
			if foundSellPointOrSellingStation[1] > 0 or foundSellPointOrSellingStation[2] > 0 then
				distance, playerPos = MissionsTimes:getDistance(foundFieldOrFarmland, foundSellPointOrSellingStation);
			end;
		end;		
		if stationName ~= nil then
			local title = g_i18n:getText("contract_details_harvesting_sellingStation").. ":";			
			if distance ~= nil and distance > 0 then 
				title = title.. " ".. g_i18n:formatDistance(distance, 0);			
				if playerPos then title = title.. " (".. g_i18n:getText("ai_parameterGroupTitleLoadingPosition").. "/".. g_i18n:getText("ui_players").. ")";end;
			end;
			g_currentMission.hlHudSystem.showInfoBox( {title.. "\n*".. tostring(stationName).. "*", 2500, g_currentMission.hlUtils.getColor("ls25active", true)} );			
		end;
	end;
end;

function MissionsTimes:getDistance(object, target) --by MissionsDisplay Mod
	local playerPos = false;
	local objectPos = {};
	local targetPos = {x=nil,y=nil,z=nil};
	if object[2] == 1 then
		local field = g_fieldManager:getFieldById(object[1]);
		if field ~= nil then objectPos.x, objectPos.y, objectPos.z = field.posX, 0, field.posZ;end;
	elseif object[2] == 2 then
		local farmland = g_farmlandManager:getFarmlandById(object[1]);
		if farmland ~= nil then objectPos.x, objectPos.y, objectPos.z = farmland.xWorldPos, 0, farmland.zWorldPos;end; 
	elseif g_localPlayer ~= nil then --by player
		objectPos.x, objectPos.y, objectPos.z = g_localPlayer:getPosition();
		playerPos = true;
	end;
	if target[1] > 0 then targetPos.x, targetPos.y, targetPos.z = getWorldTranslation(target[1]);end;
	if (targetPos.x == nil or targetPos.x == 0) and target[2] > 0 then targetPos.x, targetPos.y, targetPos.z = getWorldTranslation(target[2]);end;
	return g_currentMission.hlUtils.getObjectDistance(objectPos, targetPos), playerPos;
end;

function MissionsTimes:getMissionById(missionId)
	local mission = nil;
	for index, mission in ipairs(g_missionManager.missions) do
		if mission.id == missionId then 
			return mission;
		end;
	end;
	return mission;	
end;

function MissionsTimes:showInGameMenuFrame(frame, missionId, global, change, forceMouse) --by MissionsDisplay Mod
	if frame == nil or missionId == nil or g_gui.frames[frame] == nil or change > 1 then return;end;
	local change = change or 0;
	function setForceMouse()		
		g_currentMission.hlUtils.mouseOnOff(false, false); --force mouseOff			
	end;
	---im mp vorher abfragen ob player eine farmid hat oder	
	if frame == "ingameMenuContracts"	then
		local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
		local isMissionByPlayerFarmId = false;
		if global ~= nil and global then
			if forceMouse == nil or forceMouse then setForceMouse();end; --force mouseOff
			local show = g_gui:showGui("InGameMenu");				
			local missionPageId = show.parent.pagingElement:getPageIdByElement(show.parent.pageContracts);
			local missionPageIndex = show.parent.pagingElement:getPageMappingIndex(missionPageId);
			show.parent.pageSelector:setState(missionPageIndex, true);				
		else
			if missionId > 0 then
				if forceMouse == nil or forceMouse then setForceMouse();end; --force mouseOff
				local activeMission = false;
				local mission = MissionsTimes:getMissionById(missionId);
				if mission ~= nil then 
					activeMission = mission.finishState == 2 or mission.status == 4 or mission.isInMissionMap or (mission.activeMissionId ~= nil);						
				end;
				if activeMission and mission.farmId == playerFarmId then isMissionByPlayerFarmId = true;end;
				local show = g_gui:showGui("InGameMenu");
				local missionPageId = show.parent.pagingElement:getPageIdByElement(show.parent.pageContracts);
				local missionPageIndex = show.parent.pagingElement:getPageMappingIndex(missionPageId);					
				local subMissionPageIndex = show.parent.pagingElement:getPageMappingIndex(missionPageId);
				show.parent.pageSelector:setState(missionPageIndex, true);				
				local section = 1;
				if activeMission then section = 2;end;					
				show.parent.subCategorySelector:setState(section, true);							
				local sectionContracts = show.parent.pageContracts.sectionContracts[section];					
				if sectionContracts ~= nil and #sectionContracts > 0 then --groups/group
					for s=1, #sectionContracts do --groups
						if sectionContracts[s] ~= nil and sectionContracts[s].contracts ~= nil and #sectionContracts[s].contracts > 0 then
							for sg=1, #sectionContracts[s].contracts do --group
								if sectionContracts[s].contracts[sg] ~= nil and sectionContracts[s].contracts[sg].mission ~= nil then
									if sectionContracts[s].contracts[sg].mission.id == missionId then
										show.parent.pageContracts.contractsList:setSelectedItem(s, sg);
										return;
									end;
								end;
							end;
						end;
					end;
				end;
				MissionsTimes:showInGameMenuFrame(frame, missionId, true, change+1, forceMouse)		
			elseif change == 0 then
				MissionsTimes:showInGameMenuFrame(frame, missionId, true, change+1, forceMouse)
			end;
		end;
	end;	
end;
--needs HL Hud System--
